

***Creation input files for Pareto interpolation for income series, for men and women ***

*global projdir "W:\brtrd\Projet wealth_income\Imputation_gperc\Income"
global projdir "C:\Users\G839276\Dropbox\WIDFrance\Papers\GGP2017DINA\GGP2017DINAAppendixC\DataFiles\Results"
*global projdir "C:\Users\Bertrand\Dropbox\WIDFrance\Papers\GGP2017DINA\GGP2017DINAAppendixC\DataFiles\Results"


cd "$projdir"

/*** 1- Computing averages for men and women ***/
capture program drop interpol_share_w
program define interpol_share_w
	args typeinc year1 year2	
	
	
	*local typeinc trav_pretaxCN
	*local year1 1970
	*local year2 1975
	
	use "$projdir\gperc\gpercr`typeinc'", clear
	preserve
		keep if inlist(sex,0,1)
		sort year sex gperc
		bys year sex: gen order =_n
		keep if order==1
		keep year sex n ytop 
		reshape wide n ytop , i(year) j(sex)
		*g double shpop_m = n1/n0
		g double shmean_m=ytop1/ytop0
		keep year sh* n0  
		drop if missing(shmean_m)
	save temp_info_m_`typeinc'_`year1'_`year2',replace
	restore
	
	keep if inlist(sex,0,2)
	sort year sex gperc
	bys year sex: gen order =_n
	keep if order==1
	keep year sex n ytop 
	reshape wide n ytop , i(year) j(sex)
	g double shpop_w = n2/n0
	g double shmean_w=ytop2/ytop0
	keep year sh* n2
	drop if missing(shmean_w)
	merge 1:m year using temp_info_m_`typeinc'_`year1'_`year2'
	keep if _merge==3
	drop _merge	
	merge 1:m year using "$projdir\dperc\dpercr`typeinc'.dta"
	drop _merge
	keep if sex==0
	keep year shm* shp n0 n2
	bys year: g order=_n 
	keep if order==1
	
	if(`year1' ==1970){
		preserve
			keep if !missing(shmean_w)
			save temp_shares_`typeinc'_others, replace
		restore
	}
	reshape wide sh* n0 n2, i(order) j(year) 
	drop order	
	*** Interpolation shares ***
	*capture program drop interpol_shares
	*program define interpol_shares
	*args year1 year2
		capture drop slope* a_*
	if!(`year1'==2012 & `year2'==2015){		
		g double slope_shmean_w=(shmean_w`year2'-shmean_w`year1')/(`year2'-`year1')
		g double a_shmean_w = (shmean_w`year1'-`year1'*slope_shmean_w)
		g double slope_shmean_m=(shmean_m`year2'-shmean_m`year1')/(`year2'-`year1')
		g double a_shmean_m = (shmean_m`year1'-`year1'*slope_shmean_m)
		*g double slope_shpop_w=(shpop_w`year2'-shpop_w`year1')/(`year2'-`year1')
		*g double a_shpop_w = (shpop_w`year1'-`year1'*slope_shpop_w)
		*g double slope_shpop_m=(shpop_m`year2'-shpop_m`year1')/(`year2'-`year1')
		*g double a_shpop_m = (shpop_m`year1'-`year1'*slope_shpop_m)

		local year_min=`year1'+1
		local year_max=`year2'-1
		forvalue year = `year_min'/`year_max'{
			di `year'
			replace shmean_w`year'=a_shmean_w+slope_shmean_w*`year'
			replace shmean_m`year'=a_shmean_m+slope_shmean_m*`year'
			*replace shpop_w`year'=a_shpop_w+slope_shpop_w*`year'
			*replace shpop_m`year'=a_shpop_m+slope_shpop_m*`year'
		}
		drop slope* a_*
	}
	if(`year1'==2012 & `year2'==2015){
		replace shmean_w2013=shmean_w2012
		replace shmean_w2014=shmean_w2012
		replace shmean_m2013=shmean_m2012
		replace shmean_m2014=shmean_m2012
		*replace shpop_w2013=shpop_w2012
		*replace shpop_w2014=shpop_w2012	
	}

	gen var=1
	reshape long shmean_w shmean_m shpop_w n0 n2 /*shpop_m*/, i(var)  j(year) 
	drop var
	keep if (year > `year1' & year < `year2')
	save temp_shares_`typeinc'_`year1'_`year2',replace
	erase temp_info_m_`typeinc'_`year1'_`year2'.dta
end


capture program drop interpol_share2_w
program define interpol_share2_w
	args typeinc
	interpol_share_w `typeinc' 1970 1975
	interpol_share_w `typeinc' 1975 1979
	interpol_share_w `typeinc' 1979 1984
	interpol_share_w `typeinc' 1984 1988
	interpol_share_w `typeinc' 1988 1990
	interpol_share_w `typeinc' 1991 1994
	interpol_share_w `typeinc' 2012 2015

	use temp_shares_`typeinc'_1970_1975, clear
	append using temp_shares_`typeinc'_1975_1979
	append using temp_shares_`typeinc'_1979_1984
	append using temp_shares_`typeinc'_1984_1988
	append using temp_shares_`typeinc'_1988_1990
	append using temp_shares_`typeinc'_1991_1994	
	append using temp_shares_`typeinc'_2012_2015	
	append using temp_shares_`typeinc'_others
	save temp_shares0_`typeinc', replace
	
	erase temp_shares_`typeinc'_1970_1975.dta
	erase temp_shares_`typeinc'_1975_1979.dta
	erase temp_shares_`typeinc'_1979_1984.dta
	erase temp_shares_`typeinc'_1984_1988.dta
	erase temp_shares_`typeinc'_1988_1990.dta
	erase temp_shares_`typeinc'_1991_1994.dta
	erase temp_shares_`typeinc'_2012_2015.dta
	erase temp_shares_`typeinc'_others.dta
	
	clear
	import excel "$projdir\Pareto interpolations\averageincome_year.xlsx", sheet("averages")  cellrange(A2:L47)  firstrow clear
	drop trav_FICN_all
	merge 1:1 year using temp_shares0_`typeinc'
	br
	keep if _merge==3
	drop _merge
	keep year sh* `typeinc' /*n0 n2*/
	rename `typeinc' average
	g double average_w = shmean_w*average
	g double average_m = shmean_m*average
	*g double n2_calc = 0.01*((n0*(average - average_m))/(average_w-average_m))
	*g double sh_pop_w2 = n2/n0
	*g average_m2 = (average - shpop_w*average_w)/(1-shpop_w)
	*g diff = average_m1-average_m2
	
	keep year average*
	save average`typeinc'year_gender,replace	
	erase temp_shares0_`typeinc'.dta	
end

clear
interpol_share2_w trav_pretaxCN
interpol_share2_w trav_FICN



/**** 2- Programs with gender ****/

capture program drop interpolation_ratio
program define interpolation_ratio
	args year1 year2
	capture drop slope* /*a_**/
	g slope_ratio=(ratio_inc`year2'-ratio_inc`year1')/(`year2'-`year1')
	g  a_ratio = (ratio_inc`year1'-`year1'*slope_ratio)
	local year_min=`year1'+1
	local year_max=`year2'-1

	forvalue year = `year_min'/`year_max'{
		replace ratio_inc`year'=a_ratio+slope_ratio*`year'
		replace trav_FICN_2559`year'=ratio_inc`year'*trav_FICN_all`year'	
	}
	capture drop slope* 
	capture drop a_*
end



capture program drop interpolation_income_b_gender
program interpolation_income_b_gender
	args gender typeincome year1 year2
	
	/** To be launched the 1st time **
	/*** 0- Labor factor income for the 25-59 from national accounts factor income (all pop)***/
	/*** Writting the value in the Excel file averageincome_year.xlsx ***/
	if("`typeincome'"=="trav_FICN"){
		clear
		import excel "$projdir\Pareto interpolations\averageincome_year.xlsx", sheet("averages")  cellrange(A2:K47)  firstrow clear
		keep year `typeincome'_all
		tempfile temp2
		save `temp2',replace
		use "$projdir\gperc\gpercr`typeincome'", replace
		keep if sex==0
		keep year ymean pop
		bys year ymean pop: keep if _n==1
		rename ymean trav_FICN_2559
		rename pop pop2559
		merge m:1 year using `temp2'
		drop _merge
		g ratio_inc=trav_FICN_2559/trav_FICN_all
												
		/*** Interpolation ratio_inc ***/
		g v=1
		reshape wide trav* pop* ratio* , i(v) j(year)
			
		interpolation_ratio 1970 1975
		interpolation_ratio 1975 1979
		interpolation_ratio 1979 1984
		interpolation_ratio 1984 1988
		interpolation_ratio 1988 1990
		interpolation_ratio 1991 1994
			
		replace ratio_inc2013=ratio_inc2012
		replace ratio_inc2014=ratio_inc2012
		replace trav_FICN_25592013=ratio_inc2013*trav_FICN_all2013
		replace trav_FICN_25592014=ratio_inc2014*trav_FICN_all2014
			
		reshape long trav_FICN_2559 trav_FICN_all pop2559 ratio_inc, i(v) j(year)
		mkmat trav_FICN_2559, matrix(FICN)
		putexcel L3=matrix(FICN)   using "$projdir\Pareto interpolations\averageincome_year.xlsx", sheet("averages") modify
	}
	*** end of writting ***/
	clear
	import excel "$projdir\Pareto interpolations\averageincome_year.xlsx", sheet("averages")  cellrange(A2:L47)  firstrow clear
	drop trav_FICN_all
	keep year `typeincome'
		
	tempfile temp1
	save `temp1',replace
	use "$projdir\dperc\dpercr`typeincome'", clear
	keep if sex==`gender'
	keep year dperc share_dperc
	sort year dperc
	merge m:1 year using `temp1'
	erase `temp1'
	keep if _merge==3
	drop _merge
	g pop_share_above=1-dperc/100
	replace pop_share = round(pop_share,0.001)
	replace pop_share=0.005 if dperc==995
	replace pop_share=0.001 if dperc==999
	
	bys year: egen double sum_share=sum(share)
	summ sum_share,de
	*rescaling share to 100 because of roundings
	replace share=share*1/sum_share
	drop sum_share
	g inc_dperc = share*`typeincome'
	
	gsort year - dperc
	bys year: g double sum_ytop= sum(inc_dperc)
	bys year: g double share_top= sum(share)
	*Correction for rounding
	bys year: egen sum_cumul=sum(inc_dperc)
	replace sum_ytop=sum_ytop*`typeincome'/sum_cumul
	drop sum_cumul	
	g ytop= sum_ytop/pop_share

	tempfile temp1
	keep year dperc ytop sum_ytop `typeincome' share_dperc share_top
	save `temp1',replace

	use "$projdir\gperc\gpercr`typeincome'", replace
	keep if sex==`gender' & inlist(gperc,0,10,20,30,40,50,60,70,80,90,95,990,9990,99990)
	replace gperc=99 if gperc==990
	replace gperc=999 if gperc==9990
	replace gperc=9999 if gperc==99990
	keep year gperc thr b y0 ymean  
	rename gperc dperc
	merge 1:m year dperc using `temp1'
	sort year dperc
	keep if year >=`year1' & year <= `year2'
	keep if !(_merge==1)
	drop _merge
	replace thr=0 if missing(thr) & dperc==0
	g p = dperc/100
	replace p=0.999 if dperc==999
	drop if dperc==995
	replace share_dperc=share_top-share_top[_n+1] if dperc==99
	*rescaling
	replace thr=thr*`typeincome'/ymean
	drop ymean
	sort year dperc
	bys year: g double a=(1-((ln(share_top/share_top[_n+1]))/(ln((1-p)/(1-p[_n+1])))))^(-1)
	bys year: g double ratio_p=sum_ytop/sum_ytop[_n+1]
	reshape wide p thr b `typeincome' ytop y0 sum_ytop a ratio_p share_dperc share_top, i(dperc) j(year)
	
	**** Interpolations
	capture drop slope*
	capture drop a_*		
	g slope_y0=(y0`year2'-y0`year1')/(`year2'-`year1')
	g  a_y0 = (y0`year1'-`year1'*slope_y0)

	local year_min=`year1'+1
	local year_max=`year2'-1

	forvalue year = `year_min'/`year_max'{
		replace y0`year'=a_y0+slope_y0*`year'
		replace p`year'=0.999 if dperc==999
	}	

	preserve 
		keep y0*
		keep if _n==1
		g v=1
		reshape long y0, i(v) j(year)
		g p=round(y0,.001)
		keep year p
		g thr = 0
		g b=.
		save y0_`typeincome'_`gender'_`year1'_`year2',replace
	restore
	drop /*y0**/ slope_y0 a_y0
	save temp_`typeincome'_`gender'_`year1'_`year2',replace
end



capture program drop interpolation_income2
program interpolation_income2
	args gender typeincome year1 year2
	capture drop a_* 
	capture drop slope*
	keep dperc p* thr* b* `typeincome'* a* ytop* ratio_p* share* sum_ytop* y0*
	reshape long p thr b `typeincome' a ytop ratio_p share_dperc share_top sum_ytop y0, i(dperc) j(year)
	sort year dperc
	order dperc year `typeincome' p thr a b y0 ytop ratio_p share_dperc share_top sum_ytop
	rename `typeincome' average
	replace b=. if b==0
	replace thr=0 if missing(thr)
	append using  y0_`typeincome'_`gender'_temp
	sort year p dperc
	bys year: g t=_n
	bys year: g tb=_N
	xtset year t
	replace average = L.average if missing(average) &  p>0
	replace average = F.average if missing(average) &  p>0 & t<tb
	drop t tb
	sort year p
	replace dperc=round(100*p,1) if missing(dperc)
	keep if year>=`year1' & year <=`year2'
	bys year: gen t=p if missing(a) & !(dperc==999)
	bys year: egen t2=min(t)
	drop t 
	
	replace ytop = average/(1-p) if missing(ytop) & p==t2
	bys year p: drop if _n==2

	bys year: gen yint = (((1-p)*(ytop))-(1-p[_n+1])*(ytop[_n+1]))/(p[_n+1]-p)
	bys year: replace yint = ytop if d==999
	
	sort year p
	bys year: replace sum_ytop=sum_ytop[_n-1] if missing(sum_ytop) & p<=t2
	bys year: replace share_top=share_top[_n-1] if missing(share_top) & p<=t2
	drop if p==t2 & (missing(yint))
	
	reshape  wide average thr a b t2 ratio_p ytop share_dperc dperc yint sum_ytop share_top y0, i(p) j(year)
	br p dperc* thr* t2* yint* sum_ytop* ytop* y0*
	
	forvalue year=`year1'/`year2'{
		replace yint`year'=(sum_ytop`year'-sum_ytop`year'[_n+1])/(p[_n+1]-p) if missing(yint`year')
		replace yint`year'=yint`year'[_n-1] if missing(yint`year')
		replace t2`year'=t2`year'[_n-1] if missing(t2`year')
		replace thr`year'=0 if (missing(thr`year') & p<=t2`year' & !missing(t2`year') )
	}
	*br p dperc* thr* t2* yint* sum_ytop*
	
	local year_min=`year1'+1
	local year_max=`year2'-1
	forvalue year = `year_min'/`year_max'{
		local yearn1 = `year'-1
		*interpolation missing threshold
		replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1')
		replace b`year' =  ytop`year'/thr`year' if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1')
		
		replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1')
		replace b`year' =  ytop`year'/thr`year' if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1')
		
	}
	keep p* thr* b* a* ytop* share* dperc* yint* sum_ytop* t2* y0*
	reshape long thr b a average ytop share_dperc dperc yint sum_ytop t2 y0, i(p) j(year)
	sort year p
	order year p thr a b average ytop share_dperc dperc yint sum_ytop t2 y0
	replace b=. if b==0
	replace thr=0 if missing(thr)
	sort year p thr
	drop if missing(t2)
	sort year p thr
	
	bys year: g t=_n
	bys year: g tb=_N
	xtset year t
	replace average = L.average if missing(average) &  p>0
	replace average = F.average if missing(average) &  p>0 & t<tb
	drop t tb
	/* To produce files compatible with the website http://apps.wid.world/gpinter/ */
	keep if p>=t2
	drop if thr==0 & p>t2
	keep year average p thr b y0
	order year average p thr b
	save temp_fin_`typeincome'_`gender'_`year1'_`year2',replace
end

capture program drop export_results_gender
program export_results_gender
	args gender typeincome year
	preserve
		keep if year==`year'
		keep year average p thr b
		if `gender'==1{
		export excel using "$projdir\Pareto interpolations\for_interpolation_byyear_m_`typeincome'.xlsx", sheet("`year'")  firstrow(variables) sheetmodify
		}
		if `gender'==2{
		export excel using "$projdir\Pareto interpolations\for_interpolation_byyear_w_`typeincome'.xlsx", sheet("`year'")  firstrow(variables) sheetmodify
		}
	restore
end


capture program drop complete2_gender
program complete2_gender
	args gender typeinc 
	interpolation_income_b_gender `gender' `typeinc' 1970 1975
	interpolation_income_b_gender `gender' `typeinc' 1975 1979
	interpolation_income_b_gender `gender' `typeinc' 1979 1984
	interpolation_income_b_gender `gender' `typeinc' 1984 1988
	interpolation_income_b_gender `gender' `typeinc' 1988 1990
	interpolation_income_b_gender `gender' `typeinc' 1991 1994

	clear
	use y0_`typeinc'_`gender'_1970_1975,replace
	append using y0_`typeinc'_`gender'_1975_1979
	append using y0_`typeinc'_`gender'_1979_1984
	append using y0_`typeinc'_`gender'_1984_1988
	append using y0_`typeinc'_`gender'_1988_1990
	append using y0_`typeinc'_`gender'_1991_1994
	*drop if year > 1989
	*drop if inlist(year, 1970,1975,1979,1984,1988)
	save y0_`typeinc'_`gender'_temp,replace

	erase y0_`typeinc'_`gender'_1970_1975.dta 
	erase y0_`typeinc'_`gender'_1975_1979.dta
	erase y0_`typeinc'_`gender'_1979_1984.dta
	erase y0_`typeinc'_`gender'_1984_1988.dta
	erase y0_`typeinc'_`gender'_1988_1990.dta
	erase y0_`typeinc'_`gender'_1991_1994.dta

	clear
	use temp_`typeinc'_`gender'_1970_1975,replace
	merge m:1 dperc using temp_`typeinc'_`gender'_1975_1979
	keep if _merge==3
	drop _merge
	merge m:1 dperc using temp_`typeinc'_`gender'_1979_1984
	keep if _merge==3
	drop _merge
	merge m:1 dperc using temp_`typeinc'_`gender'_1984_1988
	keep if _merge==3
	drop _merge
	merge m:1 dperc using temp_`typeinc'_`gender'_1988_1990
	keep if _merge==3
	drop _merge
	merge m:1 dperc using temp_`typeinc'_`gender'_1991_1994
	keep if _merge==3
	drop _merge

	preserve	
	interpolation_income2 `gender' `typeinc' 1970 1975
	restore
	preserve
	interpolation_income2 `gender' `typeinc' 1975 1979
	restore
	preserve
	interpolation_income2 `gender' `typeinc' 1979 1984
	restore
	preserve
	interpolation_income2 `gender' `typeinc' 1984 1988
	restore
	preserve
	interpolation_income2 `gender' `typeinc' 1988 1990
	restore
	preserve
	interpolation_income2 `gender' `typeinc' 1991 1994
	restore
	
	clear
	use temp_fin_`typeinc'_`gender'_1970_1975,replace
	append using temp_fin_`typeinc'_`gender'_1975_1979
	append using temp_fin_`typeinc'_`gender'_1979_1984
	append using temp_fin_`typeinc'_`gender'_1984_1988
	append using temp_fin_`typeinc'_`gender'_1988_1990
	append using temp_fin_`typeinc'_`gender'_1991_1994
	order year average	p thr b
	save info_`typeinc'_`gender', replace
	drop y0

	erase temp_`typeinc'_`gender'_1970_1975.dta 
	erase temp_`typeinc'_`gender'_1975_1979.dta
	erase temp_`typeinc'_`gender'_1979_1984.dta
	erase temp_`typeinc'_`gender'_1984_1988.dta
	erase temp_`typeinc'_`gender'_1988_1990.dta
	erase temp_`typeinc'_`gender'_1991_1994.dta
	erase temp_fin_`typeinc'_`gender'_1970_1975.dta 
	erase temp_fin_`typeinc'_`gender'_1975_1979.dta
	erase temp_fin_`typeinc'_`gender'_1979_1984.dta
	erase temp_fin_`typeinc'_`gender'_1984_1988.dta
	erase temp_fin_`typeinc'_`gender'_1988_1990.dta
	erase temp_fin_`typeinc'_`gender'_1991_1994.dta

	forvalue i=1971/1974{
	export_results_gender `gender' `typeinc' `i'
	}
	forvalue i=1976/1978{
	export_results_gender `gender' `typeinc' `i'
	}
	forvalue i=1980/1983{
	export_results_gender `gender' `typeinc' `i'
	}
	forvalue i=1985/1987{
	export_results_gender `gender' `typeinc' `i'
	}
	export_results_gender `gender' `typeinc' 1989
	forvalue i=1992/1993{
	export_results_gender `gender' `typeinc' `i'
	}
	*erase y0_`typeinc'_`gender'_temp.dta	
end


/** Adding 2013 and 2014 **/
capture program drop interpolation_income3_gender 
program interpolation_income3_gender
	args gender typeincome 
	
	*local typeincome trav_FICN
	*local gender 1
	
	import excel "$projdir\Pareto interpolations\averageincome_year_gender.xlsx", sheet("averages")  cellrange(A1:G46)  firstrow clear
	if(`gender'==1){
		keep year `typeincome'_m
	}
	if(`gender'==2){
		keep year `typeincome'_w
	}
		
	tempfile temp1
	save `temp1',replace
	use "$projdir\dperc\dpercr`typeincome'", clear
	keep if sex==`gender'
	keep year dperc share_dperc
	sort year dperc
	merge m:1 year using `temp1'
	erase `temp1'
	keep if _merge==3
	drop _merge
	g pop_share_above=1-dperc/100
	replace pop_share = round(pop_share,0.001)
	replace pop_share=0.005 if dperc==995
	replace pop_share=0.001 if dperc==999

		bys year: egen double sum_share=sum(share)
		summ sum_share,de
		*rescaling share to 100 because of roundings
		replace share=share*1/sum_share
		drop sum_share
		g inc_dperc = share*`typeincome'
		
		gsort year - dperc
		bys year: g double sum_ytop= sum(inc_dperc)
		bys year: g double share_top= sum(share)
		*Correction for rounding
		bys year: egen sum_cumul=sum(inc_dperc)
		replace sum_ytop=sum_ytop*`typeincome'/sum_cumul
		drop sum_cumul
		g ytop= sum_ytop/pop_share

	tempfile temp1
	keep year dperc ytop sum_ytop `typeincome' share_dperc share_top
	save `temp1',replace
	use "$projdir\gperc\gpercr`typeincome'", replace
	br
	keep if sex==`gender' & inlist(gperc,0,10,20,30,40,50,60,70,80,90,95,990,9990,99990)
	replace gperc=99 if gperc==990
	replace gperc=999 if gperc==9990
	replace gperc=9999 if gperc==99990
	keep year gperc thr b y0 ymean
	rename gperc dperc
	merge 1:m year dperc using `temp1'
	sort year dperc
	keep if inlist(year,2012,2013,2014)
	keep if !(_merge==1)
	drop _merge
	replace thr=0 if missing(thr) & dperc==0
	g p = dperc/100
	replace p=round(p,0.001)
	replace p=0.999 if dperc==999
	drop if dperc==995
	replace share_dperc=share_top-share_top[_n+1] if dperc==99
	*rescaling
	replace thr=thr*`typeincome'/ymean
	drop ymean
		
		sort year dperc
		bys year: g double a=(1-((ln(share_top/share_top[_n+1]))/(ln((1-p)/(1-p[_n+1])))))^(-1)
		bys year: g double ratio_p=sum_ytop/sum_ytop[_n+1]
		reshape wide p thr b `typeincome' ytop y0 sum_ytop a ratio_p share_dperc share_top, i(dperc) j(year)
		/* y0 for 2013 and 2014 are set to 2012 values */
		replace y02013=y02012
		replace y02014=y02012
**
		preserve 
			keep y0*
			keep if _n==1
			g v=1
			reshape long y0, i(v) j(year)
			g p=round(y0,.001)
			keep year p
			g thr = 0
			g b=.
			append using y0_`typeincome'_`gender'_temp 
			sort year p  
			drop thr b
			rename p y0
			if(inlist("`typeincome'","irpp","irpp_equal","irpp_foy","pretaxCN","pretaxCN_equal","pretaxCN_foy")&`gender'==1){
				save "$projdir\Pareto interpolations\r_`typeincome'_m\y0_r_`typeincome'_`gender'", replace
			}
			if(inlist("`typeincome'","irpp","irpp_equal","irpp_foy","pretaxCN","pretaxCN_equal","pretaxCN_foy")&`gender'==2){
				save "$projdir\Pareto interpolations\r_`typeincome'_w\y0_r_`typeincome'_`gender'", replace
			}
			if(inlist("`typeincome'","cap","trav_FICN","trav_pretaxCN","trav_pretaxCN_equal")&`gender'==1){
				save "$projdir\Pareto interpolations\r`typeincome'_m\y0_r`typeincome'_`gender'", replace
			}
			if(inlist("`typeincome'","cap","trav_FICN","trav_pretaxCN","trav_pretaxCN_equal")&`gender'==2){
				save "$projdir\Pareto interpolations\r`typeincome'_w\y0_r`typeincome'_`gender'", replace
			}
			erase y0_`typeincome'_`gender'_temp.dta
		restore	
	**		
		
		keep dperc p* thr* b* `typeincome'_* a* ytop* ratio_p* share* sum_ytop* y0*
		if(`gender'==1){
		reshape long p thr b `typeincome'_m a ytop ratio_p share_dperc share_top sum_ytop y0, i(dperc) j(year)
		}
		if(`gender'==2){
		reshape long p thr b `typeincome'_w a ytop ratio_p share_dperc share_top sum_ytop y0, i(dperc) j(year)
		}		
		sort year dperc
		order dperc year `typeincome'* p thr a b ytop ratio_p share_dperc share_top sum_ytop y0
		rename `typeincome'_* average
		replace b=. if b==0
		replace thr=0 if missing(thr)
		br
		bys year: gen t2=y0
		br
		
		replace ytop = average/(1-p) if missing(ytop) & p==t2
		bys year p: drop if _n==2

		bys year: gen yint = (((1-p)*(ytop))-(1-p[_n+1])*(ytop[_n+1]))/(p[_n+1]-p)
		bys year: replace yint = ytop if d==999
		
		sort year p
		bys year: replace sum_ytop=sum_ytop[_n-1] if missing(sum_ytop) & p<=t2
		bys year: replace share_top=share_top[_n-1] if missing(share_top) & p<=t2
		drop if p==t2 & (missing(yint))
		reshape  wide average thr a b t2 ratio_p ytop share_dperc dperc yint sum_ytop share_top y0, i(p) j(year)
		*br p dperc* thr* t2* yint* sum_ytop* ytop*
		
		forvalue year=2013/2014{
			*retreatment for missing yint
			replace yint`year'=(sum_ytop`year'-sum_ytop`year'[_n+1])/(p[_n+1]-p) if missing(yint`year')
			replace yint`year'=yint`year'[_n-1] if missing(yint`year')
			replace thr`year'=0 if (missing(thr`year')) 
		}
		*** 0 changes ***
		
		forvalue year = 2013/2014{
			local yearn1 = `year'-1
			*interpolation missing threshold
			replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1')
			replace b`year' =  ytop`year'/thr`year' if (p>t2`year'&!missing(t2`year') & t2`year'>=t2`yearn1')
		
			replace thr`year' = thr`yearn1'*0.5*(yint`year'[_n-1]/yint`yearn1'[_n-1] + yint`year'/yint`yearn1') if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1')
			replace b`year' =  ytop`year'/thr`year' if (p>t2`yearn1'&!missing(t2`year') & t2`year'<t2`yearn1')
			
		}
		keep p* thr* b* a* ytop* share* dperc* yint* sum_ytop* t2* y0*
		reshape long thr b a average ytop share_dperc dperc yint sum_ytop t2 y0, i(p) j(year)
		sort year p
		order year p thr a b average ytop share_dperc dperc yint sum_ytop t2 y0
		replace b=. if b==0
		replace thr=0 if missing(thr)
		sort year p thr
		br
		drop if missing(t2)
		sort year p thr
		replace p=t2 if p==0 & thr==0
		
		bys year: g t=_n
		bys year: g tb=_N
		xtset year t
		replace average = L.average if missing(average) &  p>0
		replace average = F.average if missing(average) &  p>0 & t<tb
		drop t tb
		
		keep if p>=t2
		drop if thr==0 & p>t2
		keep year average p thr b y0
		save info_`gender'_`typeincome'_2013_2014,replace
		drop y0
		order year average p thr b
		save temp_fin_`gender'_`typeincome'_2013_2014,replace
		

	forvalue i=2013/2014{
	export_results_gender `gender' `typeincome' `i'
	}
	erase temp_fin_`gender'_`typeincome'_2013_2014.dta
	capture erase temp.dta
	
	use info_`gender'_`typeincome'_2013_2014, replace
	append using info_`typeincome'_`gender'
	saveold all_info_`typeincome'_`gender', replace	
	erase info_`typeincome'_`gender'.dta
	erase info_`gender'_`typeincome'_2013_2014.dta
end


/*** Launching the programs ***/
/*** gender: 1=Men ; 2=Women ***/
complete2_gender 1 trav_pretaxCN
complete2_gender 2 trav_pretaxCN
complete2_gender 1 trav_FICN
complete2_gender 2 trav_FICN

use averagetrav_FICNyear_gender, clear
rename average trav_FICN
rename average_w trav_FICN_w
rename average_m trav_FICN_m 
merge 1:m year using averagetrav_pretaxCNyear_gender
keep if _merge==3
drop _merge
rename average trav_pretaxCN
rename average_w trav_pretaxCN_w
rename average_m trav_pretaxCN_m
export excel "$projdir\Pareto interpolations\averageincome_year_gender.xlsx", sheet("averages") firstrow(variables) replace
		
 
interpolation_income3_gender 1 trav_pretaxCN
interpolation_income3_gender 2 trav_pretaxCN
interpolation_income3_gender 1 trav_FICN
interpolation_income3_gender 2 trav_FICN


